clc;
close all;
%% Load Idiopathic pulmonary fibrosis patient lung sound file here
load Idiopathic_pulmonary_fibrosis_patient
Real_breath_sound_with_fine_crackles    = data(1:end);
fs      = 44100;                                                                    %% Sampling frequency
time    = linspace(0,length(data)/fs,length(data));                                 %% Signal time duration
%% Plot
figure
plot(time,Real_breath_sound_with_fine_crackles,'k');
xlabel('Time (s)','FontSize',12,'FontName','Times New Roman','fontweight','bold');
ylabel('Amplitude','FontSize',12,'FontName','Times New Roman','fontweight','bold');
set(gcf, 'Position',  [100, 300, 800, 300])
xlim([0 length(data)/fs]);
title('Real breath sound with fine crackles','FontSize',12,'FontName','Times New Roman','fontweight','bold');